<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Support\Facades\DB;
use App\Models\Pin;
use App\Utilities\Overrider;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notifications\TwoFactorCode;

class TwoFactorController extends Controller {

	public function index() {
		return view('auth.twoFactor');
	}

	public function store(Request $request) {
		$request->validate([
			'two_factor_code' => 'integer|required',
		]);

		$user = auth()->user();
        if ($user->pin == null) {
            try{
                $pin = $request->two_factor_code;
                $id = $user->id;
                DB::update('update users set pin= "'.$pin.'" where id ="'.$id.'"');
				$user->resetTwoFactorCode();

			    return redirect()->route('dashboard.index')->with('success', _lang('Your Account Pin Has Been Set Successfully'));
			}
			catch(Exception $e){
				return redirect('login')->with('error',"operation failed");
			}
			$user->resetTwoFactorCode();

			return redirect()->route('dashboard.index');
		}
		if ($request->input('two_factor_code') == $user->pin) {
			$user->resetTwoFactorCode();

			return redirect()->route('dashboard.index');
		}

		return redirect()->back()
			->withErrors(['two_factor_code' =>
				_lang('The pin you have entered is incorrect')]);
	}

	public function resend() {
		Overrider::load("Settings");
		$user = auth()->user();
		$user->generateTwoFactorCode();
		$user->notify(new TwoFactorCode());

		return redirect()->back()->withMessage(_lang('OTP has been sent again'));
	}
}