<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Notifications\OTP;
use App\Utilities\Overrider;
use Illuminate\Http\Request;

class OTPController extends Controller {

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        date_default_timezone_set(get_option('timezone', 'Asia/Dhaka'));
    }

    public function generateOtp(Request $request) {
        if (session('transaction_data') == null) {
            return back();
        }
        $alert_col = 'col-lg-6 offset-lg-3';
        return view('backend.customer_portal.otp.show', compact('alert_col'));
    }
    
    public function cotOtp(Request $request) {
        if ($request->isMethod('get')) {
            if (session('transaction_data') == null) {
                return back();
            }
            $alert_col = 'col-lg-6 offset-lg-3';
            return view('backend.customer_portal.cot.show', compact('alert_col'));
        }else if ($request->isMethod('post')) {
            if (auth()->user()->cot == $request->input('cot')) {
                   session(['action' => route('imf')]);
                   return redirect()->route('imf');
            }else{
                return back()->with('error', _lang('Sorry, Your Provided A Wrong COT Code'));
            }
        }
    }
    
    public function imfOtp(Request $request) {
        if ($request->isMethod('get')) {
            if (session('transaction_data') == null) {
                return back();
            }
            $alert_col = 'col-lg-6 offset-lg-3';
            return view('backend.customer_portal.imf.show', compact('alert_col'));
        }else if ($request->isMethod('post')) {
            if (auth()->user()->imf == $request->input('imf')) {
                session(['action' => session('confirmdom')]);
                return redirect()->route('tax');
            }else{
                return back()->with('error', _lang('Sorry, Your Provided A Wrong IMF Code'));
            }
        }
    }
    
    public function taxOtp(Request $request) {
        if ($request->isMethod('get')) {
            if (session('transaction_data') == null) {
                return back();
            }
            $alert_col = 'col-lg-6 offset-lg-3';
            return view('backend.customer_portal.tax.show', compact('alert_col'));
        }else if ($request->isMethod('post')) {
            if (auth()->user()->tax == $request->input('tax')) {
                return redirect()->session('action');
            }else{
                
            }
        }
    }

    public function resendOtp(Request $request) {
        Overrider::load("Settings");
        auth()->user()->generateOTP();
        auth()->user()->notify(new OTP());
        return back();
    }

}