<?php

namespace App\Http\Controllers\Customer;
use App\Mail\GeneralMail;
use App\Http\Controllers\Controller;
use App\Models\OtherBank;
use App\Models\Transaction;
use App\Models\User;
use App\Notifications\OTP;
use App\Utilities\Overrider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Models\Setting;
use App\Notifications\ApprovedWireTransfer;
use App\Notifications\DomTransferSucc;
use App\Notifications\WireTransferSucc;
use App\Notifications\ExchangeSucc;
class TransferController extends Controller {

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        date_default_timezone_set(get_option('timezone', 'Asia/Dhaka'));
    }

    public function send_money(Request $request, $otp = '') {
        if ($request->isMethod('get')) {
            $alert_col = 'col-lg-8 offset-lg-2';
            return view('backend.customer_portal.send_money', compact('alert_col'));
        } else if ($request->isMethod('post')) {
            @ini_set('max_execution_time', 0);
            @set_time_limit(0);

            if (auth()->user()->allow_withdrawal == 0) {
                return back()->with('error', _lang('Sorry, Withdraw action is disabled in your account !'));
            }

            if ($otp == 'otp' && get_option('send_money_otp', 0) == 1) {
                if ($request->otp != auth()->user()->Pin) {
                    return back()->with('error', 'The Pin Provided Is Incorrect!');
                }
                $request->merge(session('transaction_data'));
            }

            $validator = Validator::make($request->all(), [
                'user_account' => 'required',
                'currency_id'  => 'required',
                'amount'       => 'required|numeric|min:1.00',
            ]);

            if ($validator->fails()) {
                if ($request->ajax()) {
                    return response()->json(['result' => 'error', 'message' => $validator->errors()->all()]);
                } else {
                    return back()
                        ->withErrors($validator)
                        ->withInput();
                }
            }

            $user = User::whereRaw('email = ? OR account_number = ?', [$request->user_account, $request->user_account])
                ->where('user_type', 'customer')
                ->where('id', '!=', auth()->id())
                ->first();

            if (!$user) {
                return back()->with('error', _lang('User Account not found !'))->withInput();
            }

            $charge = 0;

            if (get_option('transfer_fee_type') == 'percentage') {
                $charge = (get_option('transfer_fee', 0) / 100) * $request->amount;
            } else if (get_option('transfer_fee_type') == 'fixed') {
                $charge = convert_currency(base_currency_id(), $request->currency_id, get_option('transfer_fee', 0));
            }

            //Check Available Balance
            if (get_account_balance($request->currency_id) < $request->amount + $charge) {
                if (!$request->ajax()) {
                    return back()->with('error', _lang('Insufficient balance !'))->withInput();
                } else {
                    return response()->json(['result' => 'error', 'message' => _lang('Insufficient balance !')]);
                }
            }

            //OTP Operations
            if (get_option('send_money_otp', 0) == 1 && $otp == '') {
                session(['transaction_data' => $request->all()]);
                session(['action' => route('transfer.send_money', 'otp')]);

                return redirect()->route('otp.generate');
            }

            DB::beginTransaction();

            $status = get_option('send_money_action', 0) == 1 ? 1 : 2;

            //Create Debit Transactions
            $debit                  = new Transaction();
            $debit->user_id         = auth()->id();
            $debit->currency_id     = $request->input('currency_id');
            $debit->amount          = $request->input('amount') + $charge;
            $debit->fee             = $charge;
            $debit->dr_cr           = 'dr';
            $debit->type            = 'Transfer';
            $debit->method          = 'Online';
            $debit->status          = $status;
            $debit->note            = $request->input('note');
            $debit->created_user_id = auth()->id();
            $debit->branch_id       = auth()->user()->branch_id;

            $debit->save();

            //Create Credit Transactions
            $credit                  = new Transaction();
            $credit->user_id         = $user->id;
            $credit->currency_id     = $request->input('currency_id');
            $credit->amount          = $request->input('amount');
            $credit->dr_cr           = 'cr';
            $credit->type            = 'Transfer';
            $credit->method          = 'Online';
            $credit->status          = $status;
            $credit->note            = $request->input('note');
            $credit->created_user_id = auth()->id();
            $credit->branch_id       = auth()->user()->branch_id;
            $credit->parent_id       = $debit->id;

            $credit->save();

            $request->session()->forget(['transaction_data', 'action']);

            DB::commit();

            if ($status == 2) {
                return redirect()->route('transfer.successful')->with('success', _lang('Money Transfered Successfully'));
            } else if ($status == 1) {
                return redirect()->route('transfer.successful')->with('success', _lang('Transfer Request Submitted. It will deposit recipient account once approved by authority.'));
            }
        }
    }

    public function exchange_money(Request $request, $otp = '') {
        if ($request->isMethod('get')) {
            $alert_col = 'col-lg-8 offset-lg-2';
            return view('backend.customer_portal.exchange_money', compact('alert_col'));
        } else if ($request->isMethod('post')) {
            @ini_set('max_execution_time', 0);
            @set_time_limit(0);

            if (auth()->user()->allow_withdrawal == 0) {
                return back()->with('error', _lang('Sorry, Withdraw action is disabled in your account !'));
            }

            if ($otp == 'otp' && get_option('exchange_money_otp', 0) == 1) {
                if ($request->otp != auth()->user()->pin) {
                    return back()->with('error', 'The Pin Provided Is Incorrect!');
                }
                $request->merge(session('transaction_data'));
            }

            $validator = Validator::make($request->all(), [
                'currency_from' => 'required',
                'currency_to'   => 'required',
                'amount'        => 'required|numeric|min:1.00',
            ]);

            if ($validator->fails()) {
                if ($request->ajax()) {
                    return response()->json(['result' => 'error', 'message' => $validator->errors()->all()]);
                } else {
                    return back()
                        ->withErrors($validator)
                        ->withInput();
                }
            }

            $charge = 0;

            if (get_option('exchange_fee_type') == 'percentage') {
                $charge = (get_option('exchange_fee', 0) / 100) * $request->amount;
            } else if (get_option('exchange_fee_type') == 'fixed') {
                $charge = convert_currency(base_currency_id(), $request->currency_from, get_option('exchange_fee', 0));
            }

            //Check Available Balance
            if (get_account_balance($request->currency_from) < $request->amount + $charge) {
                if (!$request->ajax()) {
                    return back()->with('error', _lang('Insufficient balance !'))->withInput();
                } else {
                    return response()->json(['result' => 'error', 'message' => _lang('Insufficient balance !')]);
                }
            }

            //OTP Operations
            if (get_option('exchange_money_otp', 0) == 1 && $otp == '') {
                session(['transaction_data' => $request->all()]);
                session(['action' => route('transfer.exchange_money', 'otp')]);
                return redirect()->route('otp.generate');
            }

            DB::beginTransaction();

            $status = get_option('exchange_money_action', 0) == 1 ? 1 : 2;

            //Create Debit Transactions
            $tid = 'TRF'.rand(100000,999999);
            session(['tid' => $tid]);
            $debit                  = new Transaction();
            $debit->user_id         = auth()->id();
            $debit->tid             = $tid;
            $debit->currency_id     = $request->input('currency_from');
            $debit->amount          = $request->input('amount') + $charge;
            $debit->fee             = $charge;
            $debit->dr_cr           = 'dr';
            $debit->type            = 'Exchange';
            $debit->method          = 'Online';
            $debit->status          = $status;
            $debit->note            = $request->input('note');
            $debit->created_user_id = auth()->id();
            $debit->branch_id       = auth()->user()->branch_id;

            $debit->save();

            //Create Credit Transactions
            $tid2 = 'TRF'.rand(100000,999999);
            $credit                  = new Transaction();
            $credit->user_id         = auth()->id();
            $credit->tid             = $tid2;
            $credit->currency_id     = $request->currency_to;
            $credit->amount          = convert_currency($request->currency_from, $request->currency_to, $request->amount);
            $credit->dr_cr           = 'cr';
            $credit->type            = 'Exchange';
            $credit->method          = 'Online';
            $credit->status          = $status;
            $credit->note            = $request->input('note');
            $credit->created_user_id = auth()->id();
            $credit->branch_id       = auth()->user()->branch_id;
            $credit->parent_id       = $debit->id;

            $credit->save();
            
            $nowid = session('tid');
            $getid  = DB::select('select * from transactions where tid = :tid', ['tid' => $nowid]);
            $gid= $getid[0]->id;
            $transaction   = Transaction::find($gid);
            $transaction->status = 2;
            $transaction->save();
            
            $getid2  = DB::select('select * from transactions where parent_id = :id', ['id' => $gid]);
            $gid2= $getid2[0]->id;
            $transaction2   = Transaction::find($gid2);
            $transaction2->status = 2;
            $transaction2->save();
            try {
                $transaction2->user->notify(new ExchangeSucc($transaction, $transaction2, $tid, $tid2));
                $transaction2->user->notify(new ExchangeSucc($transaction, $transaction2, $ti));
            } catch (\Exception$e) {}
            
            $email   = auth()->user()->email;
            $message = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            </head>
            <body>
            <div style="overflow-x:auto;">
            <div>Dear '.auth()->user()->name.',</div>
            <div>You exchange of '.currency($transaction->currency->name).$request->input('amount').' to '.currency($transaction2->currency->name).$request->input('examount').' was successful with Transaction ID '.$tid.' and '.$tid2.'.<br>Login to you account for more information</div>
            
            
            </div>
            </body>
  </html>
            ';
            Overrider::load("Settings");
            $mail          = new \stdClass();
            $mail->subject = "EXCHANGE NOTIFICATION";
            $mail->body    = $message;
            
            try {
            Mail::to($email)->send(new GeneralMail($mail));
            if (!$request->ajax()) {
            } else {
            }
        } catch (\Exception$e) {
            if (!$request->ajax()) {
                return back()->with('error', _lang('Error Occured, Your email configuration is incorrect !'));
            } else {
                return response()->json(['result' => 'error', 'action' => 'update', 'message' => _lang('Error Occured, Your email configuration is incorrect !')]);
            }
        }
            
                
                
            $request->session()->forget(['transaction_data', 'action']);

            DB::commit();

            if ($status == 2) {
                return redirect()->route('transfer.successful')->with('success', _lang('Money Exchanged Successfully'));
            } else if ($status == 1) {
                return redirect()->route('transfer.successful')->with('success', _lang('Exchange Request Submitted. It will deposit to your account once approved by authority.'));
            }
        }
    }

    public function dom_transfer(Request $request, $otp = '') {
        if ($request->isMethod('get')) {
            $alert_col = 'col-lg-8 offset-lg-2';
            return view('backend.customer_portal.dom_transfer', compact('alert_col'));
        } else if ($request->isMethod('post')) {
            @ini_set('max_execution_time', 0);
            @set_time_limit(0);

            if (auth()->user()->allow_withdrawal == 0) {
                return back()->with('error', _lang('Sorry, Withdraw action is disabled in your account !'));
            }
            
            if (auth()->user()->status == 2) {
                return back()->with('error', _lang('Sorry, Your Account Has Beeen Placed On Hold'));
            }
            
            if (auth()->user()->status == 3) {
                return back()->with('error', _lang('Sorry, Your Account Has Beeen Suspended'));
            }
            
            
            if($otp == ''){
                if (auth()->user()->dom_go == 1) {
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('cot')]);
                    session(['confirmdom' => route('transfer.dom_transfer', 'go')]);
                    return redirect()->route('cot');
                }
                if(auth()->user()->dom_go == 2){
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('transfer.dom_transfer', 'go')]);
                    return redirect()->route('cot');
                }
                if(auth()->user()->dom_go == 3){
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('transfer.dom_transfer', 'go')]);
                    return redirect()->route('imf');
                }
                if(auth()->user()->dom_go == 4){
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('transfer.dom_transfer', 'go')]);
                    return redirect()->route('tax');
                }
                session(['action' => route('transfer.dom_transfer', 'otp')]);
                session(['transaction_data' => $request->all()]);
                return redirect()->route('otp.generate');
            }
            
            $validator = Validator::make($request->all(), [
                'td.bank_name'                   => 'required',
                'amount'                 => 'required|numeric',
                'td.account_number'      => 'required',
                'td.account_holder_name' => 'required',
            ]);


            if ($otp == 'otp') {
                if ($request->otp != auth()->user()->pin) {
                    return back()->with('error', 'The Pin Provided Is Incorrect!');
                }
            }
            
             
            if (get_account_balance(session('transaction_data.currency')) < session('transaction_data.amount')) {
                return back()->with('error', _lang('Insufficient balance !'))->withInput();
            }
            
            
            
            if ($otp == 'go') {
                if (auth()->user()->tax == $request->input('tax') || auth()->user()->cot == $request->input('cot') || auth()->user()->imf == $request->input('imf')) {
                    
                    session(['action' => route('transfer.dom_transfer', 'otp')]);
                    return redirect()->route('otp.generate');
                }
                
                return back()->with('error', _lang('Sorry, Your Provided A Wrong Code'));
            }
            
            $tid = 'TRF'.rand(100000,999999);
            session(['tid' => $tid]);
            $debit                      = new Transaction();
            $debit->user_id             = auth()->id();
            $debit->tid             = $tid;
            $debit->currency_id         = session('transaction_data.currency');
            $debit->amount              = session('transaction_data.amount');
            $debit->fee                 = 0;
            $debit->dr_cr               = 'dr';
            $debit->type                = 'Domestic_Transfer';
            $debit->method              = 'Manual';
            $debit->status              = 2;
            $debit->note                = session('transaction_data.note');
            $debit->other_bank_id       = 0;
            $debit->created_user_id     = auth()->id();
            $debit->branch_id           = auth()->user()->branch_id;
            $debit->transaction_details = json_encode(session('transaction_data.td'));

            $debit->save();
            $json_string = json_encode(session('transaction_data.td'));
			$json_string = json_decode($json_string, TRUE);
			

		    
		    $nowid = session('tid');
            $getid  = DB::select('select * from transactions where tid = :tid', ['tid' => $nowid]);
            $gid= $getid[0]->id;
            $transaction   = Transaction::find($gid);
                $transaction->status = 2;
                $transaction->save();
                try {
                    $transaction->user->notify(new DomTransferSucc($transaction, $nowid));
                } catch (\Exception$e) {}
            
            $email   = auth()->user()->email;
            $message = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            </head>
            <body>
            <div style="overflow-x:auto;">
            <div>Dear '.auth()->user()->name.',</div>
            <div>Your domestic transfer was successful. Below is the transfer summary.</div>
            
            <table style="border: 1px solid;border-collapse: collapse;margin: 25px 0;font-size: 0.9em;font-family: sans-serif;width: 100%;box-shadow: 0 0 20px rgba(255, 255, 255, 0.15);">
            <tbody>
                    <tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Transaction ID</th>
    					<td style="padding: 12px 15px;">'.$tid.'</td>
    				</tr>
					<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Credit/Debit</th>
    					<td style="padding: 12px 15px;">Debit</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Type</th>
    					<td style="padding: 12px 15px;">Domestic Transfer</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Amount</th>
    					<td style="padding: 12px 15px;">'.currency($transaction->currency->name).' '.session("transaction_data.amount").'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Receiver\'s Account Number</th>
    					<td style="padding: 12px 15px;">'.$json_string['account_number'].'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Receiver\'s Name</th>
    					<td style="padding: 12px 15px;">'.$json_string['account_holder_name'].'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Receiver\'s Bank</th>
    					<td style="padding: 12px 15px;">'.$json_string['bank_name'].'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Desc</th>
    					<td style="padding: 12px 15px;">'.session('transaction_data.note').'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Date/Time</th>
    					<td style="padding: 12px 15px;">'.date('d-m-y h:i:s').'</td>
    				</tr>
    				</tbody>
    				
			</table>
            </div>
            </body>
  </html>
            ';
            Overrider::load("Settings");
            $mail          = new \stdClass();
            $mail->subject = "DEBIT ALERT";
            $mail->body    = $message;
            
            try {
            Mail::to($email)->send(new GeneralMail($mail));
            if (!$request->ajax()) {
            } else {
            }
        } catch (\Exception$e) {
            if (!$request->ajax()) {
                return back()->with('error', _lang('Error Occured, Your email configuration is incorrect !'));
            } else {
                return response()->json(['result' => 'error', 'action' => 'update', 'message' => _lang('Error Occured, Your email configuration is incorrect !')]);
            }
        }
            
            
           $request->session()->forget(['transaction_data', 'action', 'whichtrf', 'tid', 'confirmdom']);
            
            

            return redirect()->route('transfer.successful')->with('success', _lang('Your Transfer Was Successful. You will receive an email containing information about this transaction.'));
        }
    }
    

    
    public function wire_transfer(Request $request, $otp = '') {
        if ($request->isMethod('get')) {
            $alert_col = 'col-lg-8 offset-lg-2';
            return view('backend.customer_portal.wire_transfer', compact('alert_col'));
        } else if ($request->isMethod('post')) {
            @ini_set('max_execution_time', 0);
            @set_time_limit(0);

            if (auth()->user()->allow_withdrawal == 0) {
                return back()->with('error', _lang('Sorry, Withdraw action is disabled in your account !'));
            }
            
            if (auth()->user()->status == 2) {
                return back()->with('error', _lang('Sorry, Your Account Has Beeen Placed On Hold'));
            }
            
            if (auth()->user()->status == 3) {
                return back()->with('error', _lang('Sorry, Your Account Has Beeen Suspended'));
            }
            if($otp == ''){
                if (auth()->user()->wire_go == 1) {
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('cot')]);
                    session(['confirmdom' => route('transfer.wire_transfer', 'go')]);
                    return redirect()->route('cot');
                }
                if(auth()->user()->wire_go == 2){
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('transfer.wire_transfer', 'go')]);
                    return redirect()->route('cot');
                }
                if(auth()->user()->wire_go == 3){
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('transfer.wire_transfer', 'go')]);
                    return redirect()->route('imf');
                }
                if(auth()->user()->wire_go == 4){
                    session(['transaction_data' => $request->all()]);
                    session(['action' => route('transfer.wire_transfer', 'go')]);
                    return redirect()->route('tax');
                }
                session(['action' => route('transfer.wire_transfer', 'otp')]);
                session(['transaction_data' => $request->all()]);
                return redirect()->route('otp.generate');
            }
            
            if ($otp == 'otp') {
                if ($request->otp != auth()->user()->pin) {
                    return back()->with('error', 'The Pin Provided Is Incorrect!');
                }
            }
            
             
            if (get_account_balance(session('transaction_data.currency')) < session('transaction_data.amount')) {
                return back()->with('error', _lang('Insufficient balance !'))->withInput();
            }
            

            $validator = Validator::make($request->all(), [
                'td.bank_name'                   => 'required',
                'amount'                 => 'required|numeric',
                'td.account_number'      => 'required',
                'td.account_holder_name' => 'required',
            ]);

            
            

            //Check Available Balance
            

            if ($otp == 'go') {
                if (auth()->user()->tax == $request->input('tax') || auth()->user()->cot == $request->input('cot') || auth()->user()->imf == $request->input('imf')) {
                    
                    session(['action' => route('transfer.wire_transfer', 'otp')]);
                    return redirect()->route('otp.generate');
                }
                
                return back()->with('error', _lang('Sorry, Your Provided A Wrong Code'));
            }
            
            
             
            $tid = 'TRF'.rand(100000,999999);
            session(['tid' => $tid]);
             $debit                     = new Transaction();
            $debit->user_id             = auth()->id();
            $debit->tid                 = $tid;
            $debit->currency_id         = session('transaction_data.currency');
            $debit->amount              = session('transaction_data.amount');
            $debit->fee                 = 0;
            $debit->dr_cr               = 'dr';
            $debit->type                = 'Wire_Transfer';
            $debit->method              = 'Manual';
            $debit->status              = 2;
            $debit->note                = session('transaction_data.note');
            $debit->other_bank_id       = 0;
            $debit->created_user_id     = auth()->id();
            $debit->branch_id           = auth()->user()->branch_id;
            $debit->transaction_details = json_encode(session('transaction_data.td'));

            $debit->save();
            
            $json_string = json_encode(session('transaction_data.td'));
			$json_string = json_decode($json_string, TRUE);
			

		  $nowid = session('tid');
            $getid  = DB::select('select * from transactions where tid = :tid', ['tid' => $nowid]);
            $gid= $getid[0]->id;
            $transaction   = Transaction::find($gid);
                $transaction->status = 1;
                $transaction->save();
                try {
                    $transaction->user->notify(new WireTransferSucc($transaction,$nowid));
                } catch (\Exception$e) {}
            
            $email   = auth()->user()->email;
            $message = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            </head>
            <body>
            <div style="overflow-x:auto;">
            <div>Dear '.auth()->user()->name.',</div>
            <div>Your wire transfer was successful. Below is the transfer summary.</div>
            
            <table style="border: 1px solid;border-collapse: collapse;margin: 25px 0;font-size: 0.9em;font-family: sans-serif;width: 100%;box-shadow: 0 0 20px rgba(255, 255, 255, 0.15);">
            <tbody>
                    <tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Transaction ID</th>
    					<td style="padding: 12px 15px;">'.$tid.'</td>
    				</tr>
					<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Credit/Debit</th>
    					<td style="padding: 12px 15px;">Debit</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Type</th>
    					<td style="padding: 12px 15px;">Wire Transfer</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Amount</th>
    					<td style="padding: 12px 15px;">'.currency($transaction->currency->name).' '.session("transaction_data.amount").'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Receiver\'s Account Number</th>
    					<td style="padding: 12px 15px;">'.$json_string['account_number'].'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Receiver\'s Name</th>
    					<td style="padding: 12px 15px;">'.$json_string['account_holder_name'].'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Receiver\'s Bank</th>
    					<td style="padding: 12px 15px;">'.$json_string['bank_name'].'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Desc</th>
    					<td style="padding: 12px 15px;">'.session('transaction_data.note').'</td>
    				</tr>
    				
    				<tr style="border-bottom: 1px solid #dddddd;">
    					<th style="padding: 12px 15px;">Date/Time</th>
    					<td style="padding: 12px 15px;">'.date('d-m-y h:i:s').'</td>
    				</tr>
    				</tbody>
    				
			</table>
            </div>
            </body>
  </html>
            ';
            Overrider::load("Settings");
            $mail          = new \stdClass();
            $mail->subject = "DEBIT ALERT";
            $mail->body    = $message;
            
            try {
            Mail::to($email)->send(new GeneralMail($mail));
            if (!$request->ajax()) {
            } else {
            }
        } catch (\Exception$e) {
            if (!$request->ajax()) {
                return back()->with('error', _lang('Error Occured, Your email configuration is incorrect !'));
            } else {
                return response()->json(['result' => 'error', 'action' => 'update', 'message' => _lang('Error Occured, Your email configuration is incorrect !')]);
            }
        }


            $request->session()->forget(['transaction_data', 'action', 'whichtrf', 'tid', 'confirmdom']);

            return redirect()->route('transfer.successful')->with('success', _lang('Your Transfer Was Successful. You will receive an email containing information about this transaction.'));
        }
    }
    
    public function successful(){
        $alert_col = 'col-lg-8 offset-lg-2';
            return view('backend.customer_portal.successful.show', compact('alert_col'));
    }
    
    public function get_other_bank_details($id) {
        $bank = \App\Models\OtherBank::with('currency')->find($id);
        return response()->json($bank);
    }

    public function get_exchange_amount($from, $to, $amount){
        $amount = convert_currency($from, $to, $amount);
        return response()->json(['amount' => $amount]);
    }

    public function show_transaction($id) {
        if (request()->ajax()) {
            $transaction = \App\Models\Transaction::where('id', $id)->where('user_id', auth()->id())->first();
            return view('backend.customer_portal.transaction_details', compact('transaction'));
        }
        return back();
    }

}