<?php

namespace App\Notifications;

use App\Channels\SmsMessage;
use App\Models\EmailSMSTemplate;
use App\Utilities\Overrider;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DomTransferSucc extends Notification {
    use Queueable;

    private $transaction;
    private $template;
    private $replace = [];

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($transaction, $tid) {
        Overrider::load("Settings");
        $this->transaction = $transaction;
        $this->template    = EmailSMSTemplate::where('slug', 'DOM_TRANSFER_SUCCESSFUL')->first();

        $this->replace['name']     = $this->transaction->user->name;
        $this->replace['email']    = $this->transaction->user->email;
        $this->replace['tid']    = $tid;
        $this->replace['phone']    = $this->transaction->user->phone;
        $this->replace['amount']   = decimalPlace($this->transaction->amount, currency($this->transaction->currency->name));
        $this->replace['dateTime'] = $this->transaction->created_at;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable) {
        $channels = ['database'];
    
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */


    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable) {
        $message = processShortCode($this->template->sms_body, $this->replace);
        return ['message' => $message];
    }
}
