@extends('layouts.loghead')

@section('content')


<div class="signup-login">
    <div class="sl-slider-caro owl-carousel">
        <div class="single-sl-slide">
            <img src="frontassets/images/mac.png" alt="">
            <div class="content-box">
                <h2>All In One Transfer Solutions</h2>
                <p>Transfer fund across countries in minutes and our fund transfer is instantly.</p>
            </div>
        </div>
        <div class="single-sl-slide">
            <img src="frontassets/images/online-payment.png" alt="">
            <div class="content-box">
                <h2>Online Payments</h2>
                <p>Process all payment at lightning speed online.</p>
            </div>
        </div>
        <div class="single-sl-slide">
            <img src="frontassets/images/internet-bill.png" alt="">
            <div class="content-box">
                <h2>Internet Bills</h2>
                <p>Pay your bills online with ease.</p>
            </div>
        </div>
    </div>


    <div class="sl-form-wrap">
        <header>
            <a href="#" class="logo">
                <img src="assets/image/logi.png" style="width:300px !important" alt="">
            </a>
            <a href="#" class="mbl-menu-toggler">
                <i class="fas fa-align-left"></i>
            </a>
        </header>
        
        <div class="pannel">
        <div class="content-box">
            <h2>Login Account</h2>
            <p>Fill the form below to login to your Dynamic Credit Bank account.</p>
        </div>
                    @if(Session::has('error'))
                        <div class="alert alert-danger text-center">
                            <strong>{{ session('error') }}</strong>
                        </div>
                    @endif

                    @if ($errors->has('two_factor_expired'))
                        <div class="alert alert-danger text-center">
                            <strong>{{ $errors->first('two_factor_expired') }}</strong>
                        </div>
                    @endif

					@if(Session::has('registration_success'))
                        <div class="alert alert-success text-center">
                            <strong>{{ session('registration_success') }}</strong>
                        </div>
                    @endif
        <form method="POST" class="sl-form" action="{{ route('login') }}">
            @csrf
            <div class="form-group">
                <label>Account Number</label>
                <input id="email" type="number" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" placeholder="Enter Account Number" id="email" >
                                @if ($errors->has('email'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" placeholder="Enter Account Password" id="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" required>
                @if ($errors->has('password'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
            </div>
            <div class="form-check">
                <input type="checkbox" name="remember" class="form-check-input" id="remember" {{ old('remember') ? 'checked' : '' }}>
                <label class="form-check-label">Remember Password</label>
            </div>


            <button type="submit" name= 'submit' class="btn btn-filled btn-round" id="login-btn"><span class="bh"></span> <span>Login</span></button>
            <p class="notice">Don’t have an account? <a href="/register">Signup Now</a></p>
            
            <div class="form-group row mt-3">
                            <div class="col-md-12">
								<a class="btn-link" href="{{ route('password.request') }}">
									Forgot Password?
								</a>
							</div>
                        </div>
        </form>
        </div>
    </div>
</div>

<!--Start of Tawk.to Script-->
@endsection