@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header">
				<h4 class="header-title text-center">{{ _lang('Domestic Transfer') }}</h4>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="{{ route('transfer.dom_transfer') }}" enctype="multipart/form-data">
					{{ csrf_field() }}
					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
							    <label class="control-label">{{ _lang('Bank Name') }}</label>
								<select class="form-control auto-select select2" required name="td[bank_name]">
								    <option value="">{{ _lang('Select One') }}</option>
								    <option class="bankku">Abbey National</option>
<option class="bankku">ABC International Bank plc</option>
<option class="bankku">The Access Bank UK Limited</option>
<option class="bankku">ADIB (UK) Ltd</option>	
<option class="bankku">Ahli United Bank (UK)</option>
<option class="bankku">AIB Group (UK) plc</option>
<option class="bankku">Al Rayan Bank plc</option>
<option class="bankku">Aldermore Bank plc</option>
<option class="bankku">Alliance Trust Savings Limited</option>
<option class="bankku">Allica Bank	Independent</option>
<option class="bankku">Alpha Bank London Limited</option>
<option class="bankku">ANZ Bank (Europe) Limited</option>
<option class="bankku">Arbuthnot Latham & Co Limited</option>
<option class="bankku">Atom Bank plc	</option>
<option class="bankku">Axis Bank UK Limited</option>
<option class="bankku">Bank and Clients plc</option>
<option class="bankku">Bank Leumi (UK) plc</option>
<option class="bankku">Bank Mandiri (Europe) Limited	Bank </option>
<option class="bankku">Bank of America Merrill</option>
<option class="bankku">Bank of Baroda (UK) Ltd</option>
<option class="bankku">Bank of Beirut (UK) Ltd	</option>
<option class="bankku">Bank of Ceylon (UK) Ltd</option>
<option class="bankku">Bank of China (UK) Ltd</option>
<option class="bankku">Bank of Communications (UK) Limited</option>
<option class="bankku">Bank of Cyprus UK Limited</option>
<option class="bankku">Bank of India UK</option>
<option class="bankku">Bank of Ireland (UK) Plc</option>
<option class="bankku">Bank of London</option>
<option class="bankku">Bank of London and The Middle East plc	</option>
<option class="bankku">The Bank of New York Mellon (International) Limited</option>
<option class="bankku">Bank of Scotland plc	</option>
<option class="bankku">Bank of the Philippine Islands (Europe) plc</option>
<option class="bankku">Bank Saderat plc</option>
<option class="bankku">Bank Sepah International plc</option>
<option class="bankku">Barclays Bank plc</option>
<option class="bankku">BFC Bank Ltd</option>
<option class="bankku">BIRA Bank Ltd	</option>
<option class="bankku">BMCE Bank International plc</option>
<option class="bankku">British Arab Commercial Bank plc</option>
<option class="bankku">Brown Shipley & Co Limited</option>
<option class="bankku">C. Hoare & Co	</option>
<option class="bankku">CAF Bank Ltd	</option>
<option class="bankku">Cambridge & Counties Bank Limited</option>
<option class="bankku">Cashplus Bank</option>
<option class="bankku">Cater Allen Limited</option>
<option class="bankku">Charity Bank Limited	</option>
<option class="bankku">Charter Court Financial Services Limited</option>
<option class="bankku">China Construction Bank (London) Limited</option>
<option class="bankku">CIBC World Markets plc</option>
<option class="bankku">ClearBank Ltd	</option>
<option class="bankku">Close Brothers Limited</option>
<option class="bankku">Clydesdale Bank plc</option>
<option class="bankku">Commercial and Northern Ltd	</option>
<option class="bankku">The Co-operative Bank plc	</option>
<option class="bankku">Coutts & Company</option>
<option class="bankku">Credit Suisse (UK) Limited	Credit</option>
<option class="bankku">Credit Suisse International	Credit</option>
<option class="bankku">Crown Agents Bank Limited</option>
<option class="bankku">DB UK Bank Limited</option>
<option class="bankku">Diamond Bank (UK) plc</option>
<option class="bankku">Duncan Lawrie Limited</option>
<option class="bankku">EFG Private Bank Limited</option>
<option class="bankku">Europe Arab Bank plc</option>
<option class="bankku">FBN Bank (UK) Ltd</option>
<option class="bankku">FCE Bank plc</option>
<option class="bankku">FCMB Bank (UK) Limited</option>
<option class="bankku">Gatehouse Bank plc	</option>
<option class="bankku">GE Capital Bank Limited</option>
<option class="bankku">Ghana International Bank plc	</option>
<option class="bankku">Goldman Sachs International Bank</option>
<option class="bankku">Guaranty Trust Bank (UK) Limited</option>
<option class="bankku">Gulf International Bank (UK) Limited</option>
<option class="bankku">Habib Bank Zurich Plc</option>
<option class="bankku">Habibsons Bank Limited</option>
<option class="bankku">Hampden & Co Plc	</option>
<option class="bankku">Hampshire Trust Bank Plc	</option>
<option class="bankku">Havin Bank Ltd	</option>
<option class="bankku">HSBC Bank Plc</option>
<option class="bankku">HSBC Trust Company (UK) Ltd</option>
<option class="bankku">ICBC (London) plc</option>
<option class="bankku">ICBC Standard Bank Plc</option>
<option class="bankku">ICICI Bank UK Plc</option>
<option class="bankku">Investec Bank PLC</option>
<option class="bankku">Itau BBA International PLC</option>
<option class="bankku">J.P. Morgan Europe Limited</option>
<option class="bankku">J.P. Morgan International Bank Limited</option>
<option class="bankku">J.P. Morgan Securities plc</option>
<option class="bankku">Jordan International Bank Plc</option>
<option class="bankku">Julian Hodge Bank Limited</option>
<option class="bankku">KEB Hana Bank</option>
<option class="bankku">Kexim Bank (UK) Ltd</option>
<option class="bankku">Kingdom Bank Ltd</option>
<option class="bankku">SG Kleinwort Hambros Bank Limited</option>
<option class="bankku">Kookmin Bank International Limited</option>
<option class="bankku">Lloyds Bank Plc</option>
<option class="bankku">Lloyds Bank Private Banking Limited</option>
<option class="bankku">Macquarie Bank International Ltd</option>
<option class="bankku">Marks & Spencer Financial Services</option>
<option class="bankku">Masthaven Bank Limited	</option>
<option class="bankku">Melli Bank plc	Bank Melli Iran	Iran</option>
<option class="bankku">Methodist Chapel Aid Limited	</option>
<option class="bankku">Metro Bank PLC	</option>
<option class="bankku">MUFG</option>
<option class="bankku">Mizuho International Plc</option>
<option class="bankku">Monzo Bank Ltd	</option>
<option class="bankku">Morgan Stanley Bank International Limited</option>
<option class="bankku">National Bank of Egypt (UK) Limited</option>
<option class="bankku">National Bank of Kuwait (International) Plc</option>
<option class="bankku">National Westminster Bank Plc</option>
<option class="bankku">Nomura Bank International Plc</option>
<option class="bankku">Northern Bank Limited</option>
<option class="bankku">Northern Trust Global Services Ltd</option>
<option class="bankku">OakNorth Bank Limited	</option>
<option class="bankku">OneSavings Bank Plc</option>
<option class="bankku">Paragon Bank Plc</option>
<option class="bankku">PCF Group Plc	</option>
<option class="bankku">Persia International Bank Plc</option>
<option class="bankku">Philippine National Bank (Europe) Plc</option>
<option class="bankku">Punjab National Bank (International) Limited</option>
<option class="bankku">QIB (UK) Plc</option>
<option class="bankku">R. Raphael & Sons Plc</option>
<option class="bankku">Rathbone Investment Management Limited	</option>
<option class="bankku">RBC Europe Limited</option>
<option class="bankku">Reliance Bank Ltd</option>	
<option class="bankku">Royal Bank of Scotland Plc</option>
<option class="bankku">Sainsbury's Bank Plc	</option>
<option class="bankku">Santander UK Plc</option>
<option class="bankku">Schroder & Co Ltd	</option>
<option class="bankku">Scotiabank Europe Plc</option>
<option class="bankku">Scottish Widows Bank Plc	</option>
<option class="bankku">Secure Trust Bank Plc	</option>
<option class="bankku">Shawbrook Bank Limited</option>
<option class="bankku">Smith & Williamson Investment Services Limited</option>
<option class="bankku">Sonali Bank (UK) Limited</option>
<option class="bankku">Standard Chartered Bank</option>
<option class="bankku">Starling Bank Limited</option>
<option class="bankku">State Bank of India (UK) Limited</option>
<option class="bankku">Sumitomo Mitsui Banking Corporation</option>
<option class="bankku">Tandem Bank Limited	</option>
<option class="bankku">TD Bank Europe Limited</option>
<option class="bankku">Tesco Personal Finance Plc	</option>
<option class="bankku">TSB Bank plc	</option>
<option class="bankku">Turkish Bank (UK) Ltd	</option>
<option class="bankku">UBS Limited	</option>
<option class="bankku">Ulster Bank Ltd	</option>
<option class="bankku">Union Bank of India (UK) Limited</option>
<option class="bankku">Union Bank UK Plc</option>
<option class="bankku">United National Bank Limited</option>
<option class="bankku">United Trust Bank Limited</option>
<option class="bankku">Unity Trust Bank Plc</option>
<option class="bankku">Vanquis Bank Limited</option>
<option class="bankku">Virgin Money</option>
<option class="bankku">VTB Capital plc	VTB Bank</option>
<option class="bankku">Weatherbys Bank Limited</option>
<option class="bankku">Wesleyan Bank Limited</option>
<option class="bankku">Westpac Europe Ltd</option>
<option class="bankku">Wyelands Bank Plc</option>
<option class="bankku">Yorkshire Bank</option>
<option class="bankku">Zenith Bank (UK) Limited</option>
<option class="bankku">Zopa Bank Ltd</option>
								</select>
							</div>
						</div>
						
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label">{{ _lang('Beneficiary Account Number') }}</label>
								<input type="text" class="form-control" name="td[account_number]" value="{{ old('td.account_number') }}" required>
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label">{{ _lang('Beneficiary Account Name') }}</label>
								<input type="text" class="form-control" name="td[account_holder_name]" value="{{ old('td.account_holder_name') }}" required>
							</div>
						</div>
						

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label">{{ _lang('Account Type') }}</label>
								<select class="form-control auto-select select2" required name="td[acc_type]">
									<option value="">{{ _lang('Select One') }}</option>
									<option value="Savings">Savings Account</option>
                                        <option value="Current">Current Account</option>
                                        <option value="Checking">Checking Account</option>
                                        <option value="Fixed Deposit">Fixed Deposit</option>
                                        <option value="Non Resident">Non Resident Account</option>
                                        <option value="Online Banking">Online Banking</option>
                                        <option value="Domicilary Account">Domicilary Account</option>
                                        <option value="Joint Account">Joint Account</option>
								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label">{{ _lang('Currency') }}</label>
								<select class="form-control auto-select select2"  name="currency" id="currency" required>
								    <option value="">{{ _lang('Select One') }}</option>
									{{ create_option('currency','id','name','',array('status=' => 1)) }}
								</select>
							</div>
						</div>


						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label">{{ _lang('Amount') }}</label>
								<input type="text" class="form-control float-field" name="amount" value="{{ old('amount') }}" required>
								<small id="amount_limit"></small>
								<p class="text-info" id="fee"></p>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label">{{ _lang('Narration') }}</label>
								<textarea class="form-control" name="note">{{ old('note') }}</textarea>
							</div>
						</div>

						<div class="col-md-12">
							<h6 id="instructions"></h6>
						</div>

						<div class="col-md-12 mt-4">
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-lg btn-block"><i class="icofont-check-circled"></i> {{ _lang('Submit') }}</button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>

@endsection

@section('js-script')
<!--<script>-->
<!--(function ($) {-->
<!--  "use strict";-->
<!--	$(document).on('change','#bank',function(){-->
<!--		if($(this).val() != ''){-->
<!--			$.ajax({-->
<!--				url: "{{ route('transfer.get_other_bank_details') }}" + "/" + $(this).val(),-->
<!--				success: function(data){-->
<!--					var currency = data['currency']['name'];-->
<!--					$("#swift_code").val(data['swift_code']);-->
<!--					$("#currency").val(currency);-->
<!--					$("#instructions").html(data['descriptions']);-->
<!--					$("#fee").html("{{ _lang('Transaction Fee') }} " + currency +' '+ data['fixed_charge'] + " + " + data['charge_in_percentage'] + "%");-->
<!--					$("#amount_limit").text("{{ _lang('Transfer Limit') }} (" + currency + " " + data['minimum_transfer_amount'] + " - " + currency + " " + data['maximum_transfer_amount'] + ")");-->
<!--				}-->
<!--			})-->
<!--		}-->
<!--	});-->
<!--})(jQuery);-->
<!--</script>-->
@endsection


