@extends('layouts.app')

@section('content')
	@if(Auth::user()->user_type == 'customer' && Auth::user()->document_verified_at == null && get_option('enable_kyc') == 'yes')
		<div class="row">
			<div class="col-lg-12">
				<div class="alert alert-danger">
					<strong><i class="mdi mdi-information-outline"></i> {{ _lang('Your account is not verified. Please submit all necessary documents') }}. <a href="{{ route('profile.document_verification') }}">{{ _lang('Submit Documents') }} </a></strong>
				</div>
			</div>
		</div>
	@endif

	<div class="row">
		<div class="col-xl-12">
			<div class="card mb-4">
				<div class="card-body" style="background-color:#096166;color:#fff">
					<h6>{{ _lang('Account Number') }}</h6>
					<h6 class="pt-1"><b>{{ Auth::user()->account_number }}</b></h6>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
	    
		@foreach($account_balance as $currency)
		@if($currency->name == 'USD')
		<div class="col-md">
		    <div class="accbalfor1">
			<div class="card mb-4">
			    
				<div class="card-body" style="background-color:#009B4D;">
					<h6 style="color:#fff;font-weight:bold" class="bol1">{{ $currency->name.' '._lang('Balance') }}</h6>
					<h6 class="pt-1 bal1" style="color:#fff;"><b>{{ decimalPlace($currency->balance, currency($currency->name)) }}</b></h6>
				</div>
			</div>
		</div>
		</div>
		@endif
		@endforeach
		
		@foreach($account_balance as $currency)
				@if($currency->name == 'EUR')
		<div class="col-md">
		    <div class="accbalfor2">
			<div class="card mb-4">
			    
				<div class="card-body" style="background-color:#0C8A80;">
					<h6 style="color:#fff;font-weight:bold" class="bol2">{{ $currency->name.' '._lang('Balance') }}</h6>
					<h6 class="pt-1 bal2" style="color:#fff;"><b>{{ decimalPlace($currency->balance, currency($currency->name)) }}</b></h6>
				</div>
			</div>
		</div>
		</div>
		@endif
		@endforeach
		
		@foreach($account_balance as $currency)
				@if($currency->name == 'GBP')
		<div class="col-md">
		    <div class="accbalfor3">
			<div class="card mb-4">
			    
				<div class="card-body" style="background-color:#FFAB2D;">
					<h6 style="color:#fff;font-weight:bold" class="bol3">{{ $currency->name.' '._lang('Balance') }}</h6>
					<h6 class="pt-1 bal3" style="color:#fff;"><b>{{ decimalPlace($currency->balance, currency($currency->name)) }}</b></h6>
				</div>
			</div>
		</div>
		</div>
		@endif
		@endforeach
		
	</div>
<!--<div class="row">-->
<!--                      <div class="col-sm-4">-->
<!--                        <div class="card mb-3 mb-sm-0">-->
                          
<!--                           <div class="cardcc" style="width: 100%;">-->
<!--  <div class="cardcc__front cardcc__part">-->
<!--    <img class="cardcc__front-square cardcc__square" src="icon/chip.png">-->
<!--    <img class="cardcc__front-logo cardcc__logo" src="icon/visa.png">-->
<!--    <p class="cardcc_numer">1</p>-->
<!--    <div class="cardcc__space-75">-->
<!--      <span class="cardcc__label">card holder</span>-->
<!--      <p class="cardcc__info">Reals&nbsp;Techs</p>-->
<!--    </div>-->
<!--    <div class="cardcc__space-25">-->
<!--      <span class="cardcc__label">Expires</span>-->
<!--            <p class="cardcc__info">2/3</p>-->
<!--    </div>-->
<!--  </div>-->
  
<!--  <div class="cardcc__back cardcc__part">-->
<!--    <div class="cardcc__black-line"></div>-->
<!--    <div class="cardcc__back-content">-->
<!--      <div class="cardcc__secret">-->
<!--        <p class="cardcc__secret--last">4</p>-->
<!--      </div>-->
<!--      <img class="cardcc__back-square cardcc__square" src="icon/chip.png">-->
<!--      <img class="cardcc__back-logo cardcc__logo" src="icon/visa.png">-->
      
<!--    </div>-->
<!--  </div>-->
  
<!--</div>-->
                      
<!--                        </div>-->
<!--                      </div>-->
                      
<!--                      <div class="col">&nbsp;</div>-->
<!--                      <div class="col">-->
                        
       
                    
                         
                       
                       
<!-- <div class="cardcc1">-->
<!--  <div class="cardcc1__front cardcc1__part">-->
<!--    <img class="cardcc1__front-square cardcc1__square" src="icon/chip.png">-->
<!--<img class="cardcc1__front-logo cardcc1__logo" src="../assets/img/brand/white.png" alt="logo" height="60px">-->
<!--    <p class="cardcc1_numer"> 7</p>-->
<!--    <div class="cardcc1__space-75">-->
<!--      <span class="cardcc1__label">card holder</span>-->
<!--      <p class="cardcc1__info">Reals&nbsp;Techs</p>-->
<!--    </div>-->
<!--    <div class="cardcc1__space-25">-->
<!--      <span class="cardcc1__label">Type</span>-->
<!--            <p class="cardcc1__info" style="font-size:12px;">Savings</p>-->
<!--    </div>-->
<!--  </div>-->
  
<!--  <div class="cardcc1__back cardcc1__part">-->
<!--    <div class="cardcc1__black-line"></div>-->
<!--    <div class="cardcc1__back-content">-->
<!--      <div class="cardcc1__secret">-->
<!--        <p class="cardcc1__secret--last">1234</p>-->
<!--      </div>-->
<!--      <img class="cardcc1__back-square cardcc1__square" src="icon/chip.png">-->
<!--      <img class="cardcc1__back-logo cardcc1__logo" src="../assets/img/brand/white.png" alt="logo" height="40px">-->
      
<!--    </div>-->
<!--  </div>-->
  
<!--</div>-->
                       
<!--                   </div>   -->
                      
                      
<!--                    </div>-->
	<div class="row">

		<div class="col-xl-3 col-md-6 mb-4">
			<div class="card h-100 border-bottom-card border-danger tfor1">
				<div class="card-body accfor1">
					<div class="d-flex">
						<div class="flex-grow-1">
							<h6>{{ _lang('Active Loans') }}</h6>
							<h6 class="pt-1 mb-0"><b>{{ $loans->count() }}</b></h6>
						</div>
						<div>
							<a href="{{ route('loans.my_loans') }}"><i class="icofont-arrow-right"></i>{{ _lang('View') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="col-xl-3 col-md-6  mb-4">
			<div class="card h-100 border-bottom-card border-info tfor2">
				<div class="card-body accfor2">
					<div class="d-flex">
						<div class="flex-grow-1">
							<h6>{{ _lang('Payment Requests') }}</h6>
							<h6 class="pt-1 mb-0"><b>{{ $payment_request }}</b></h6>
						</div>
						<div>
							<a href="{{ route('payment_requests.index') }}"><i class="icofont-arrow-right"></i>{{ _lang('View') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="col-xl-3 col-md-6  mb-4">
			<div class="card h-100 border-bottom-card border-success tfor3">
				<div class="card-body accfor3">
					<div class="d-flex">
						<div class="flex-grow-1">
							<h6>{{ _lang('Active Fixed Deposits') }}</h6>
							<h6 class="pt-1 mb-0"><b>{{ $active_fdr }}</b></h6>
						</div>
						<div>
							<a href="{{ route('fixed_deposits.history') }}"><i class="icofont-arrow-right"></i>{{ _lang('View') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="col-xl-3 col-md-6  mb-4">
			<div class="card h-100 border-bottom-card border-info tfor4">
				<div class="card-body accfor4">
					<div class="d-flex">
						<div class="flex-grow-1">
							<h6>{{ _lang('Active Tickets') }}</h6>
							<h6 class="pt-1 mb-0"><b>{{ $active_tickets }}</b></h6>
						</div>
						<div>
							<a href="{{ route('tickets.my_tickets',['status' => 'active']) }}"><i class="icofont-arrow-right"></i>{{ _lang('View') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
<div class="options">
   <div class="option active 1s" style="--optionBackground:url(../../../1.jpg);">
      <div class="shadow"></div>
      <div class="label">
         <div class="icon">
            <i class="fas fa-walking"></i>
         </div>
        
      </div>
   </div>
   <div class="option 2s" style="--optionBackground:url(../../../2.jpg);">
      <div class="shadow"></div>
      <div class="label">
         <div class="icon">
            <i class="fas fa-snowflake"></i>
         </div>
        
      </div>
   </div>
   <div class="option 3s" style="--optionBackground:url(../../../3.jpg);">
      <div class="shadow"></div>
      <div class="label">
         <div class="icon">
            <i class="fas fa-tree"></i>
         </div>
      </div>
   </div>
   <div class="option 4s" style="--optionBackground:url(../../../4.jpg);">
      <div class="shadow"></div>
      <div class="label">
         <div class="icon">
            <i class="fas fa-tint"></i>
         </div>
      </div>
   </div>
   <div class="option 5s" style="--optionBackground:url(../../../5.jpg);">
      <div class="shadow"></div>
      <div class="label">
         <div class="icon">
            <i class="fas fa-sun"></i>
         </div>
      </div>
   </div>
</div>
	<div class="row">
		<div class="col-lg-12">
			<div class="card mb-4 ">
				<div class="card-header uuij1" style="background-color:#2A3F65;color:#fff">
					{{ _lang('Up Comming Loan Payment') }}
				</div>
				<div class="card-body uuij2">
					<div class="table-responsive">
						<table class="table table-bordered">
							<thead>
								<th>{{ _lang('Loan ID') }}</th>
								<th>{{ _lang('Next Payment Date') }}</th>
								<th>{{ _lang('Status') }}</th>
								<th class="text-right">{{ _lang('Amount to Pay') }}</th>
								<th class="text-center">{{ _lang('Action') }}</th>
							</thead>
							<tbody>
								@if(count($loans) == 0)
									<tr>
										<td colspan="5"><h6 class="text-center">{{ _lang('No Active Loan Available') }}</h6></td>
									</tr>
								@endif

								@foreach($loans as $loan)
								<tr>
									<td>{{ $loan->loan_id }}</td>
									<td>{{ $loan->next_payment->repayment_date }}</td>
									<td>{!! $loan->next_payment->repayment_date >= date('Y-m-d') ? xss_clean(show_status(_lang('Upcoming'),'success')) : xss_clean(show_status(_lang('Due'),'danger')) !!}</td>
									<td class="text-right">{{ decimalPlace($loan->next_payment->amount_to_pay, currency($loan->currency->name)) }}</td>
									<td class="text-center"><a href="{{ route('loans.loan_payment',$loan->id) }}" class="btn btn-primary btn-sm">{{ _lang('Pay Now') }}</a></td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-lg-12">
			<div class="card mb-4 ">
				<div class="card-header uuij2" style="background-color:#2A3F65;color:#fff">
					{{ _lang('Recent Transactions') }}
				</div>
				<div class="card-body uuij1">
					<div class="table-responsive">
						<table class="table table-bordered">
							<thead>
								<tr>
								    <th>{{ _lang('Transaction ID') }}</th>
									<th>{{ _lang('Date') }}</th>
									<th>{{ _lang('Currency') }}</th>
									<th>{{ _lang('Amount') }}</th>
									<th>{{ _lang('Charge') }}</th>
									<th>{{ _lang('Grand Total') }}</th>
									<th>{{ _lang('DR/CR') }}</th>
									<th>{{ _lang('Type') }}</th>
									<th>{{ _lang('Method') }}</th>
									<th>{{ _lang('Status') }}</th>
								</tr>
							</thead>
							<tbody>
								@foreach($recent_transactions as $transaction)
								@php
								$symbol = $transaction->dr_cr == 'dr' ? '-' : '+';
								$class  = $transaction->dr_cr == 'dr' ? 'text-danger' : 'text-success';
								@endphp
								<tr>
								    <td>{{ $transaction->tid }}</td>
									<td>{{ $transaction->created_at }}</td>
									<td>{{ $transaction->currency->name }}</td>
									@if($transaction->dr_cr == 'dr')
									<td>{{ decimalPlace(($transaction->amount - $transaction->fee), currency($transaction->currency->name)) }}</td>
									@else
									<td>{{ decimalPlace(($transaction->amount + $transaction->fee), currency($transaction->currency->name)) }}</td>
									@endif
									<td>{{ $transaction->dr_cr == 'dr' ? '+ '.decimalPlace($transaction->fee, currency($transaction->currency->name)) : '- '.decimalPlace($transaction->fee, currency($transaction->currency->name)) }}</td>
									<td><span class="{{ $class }}">{{ $symbol.' '.decimalPlace($transaction->amount, currency($transaction->currency->name)) }}</span></td>
									<td>{{ strtoupper($transaction->dr_cr) }}</td>
									<td>{{ str_replace('_',' ',$transaction->type) }}</td>
									<td>{{ $transaction->method }}</td>
									<td>{!! xss_clean(transaction_status($transaction->status)) !!}</td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
<script>

$(document).ready(function(){
var i = 1;
var b = 1;
  function next_slide(){
        $(`.${i}s`).removeClass("active");
        if(i >= 5){
            i = 0;
        }
        i += 1;
        $(`.${i}s`).addClass("active");
    
}
    
  
  var SECONDS_INTERVAL = 1000; // 1s
    var mouseHoverFlag = false;

    setInterval(function() {
        if (!mouseHoverFlag) {
            next_slide();
        }
    }, SECONDS_INTERVAL);
    $('.option').hover(function() {
        mouseHoverFlag = true;
    }, function () {
        mouseHoverFlag = false;
    });
});
</script>
<script>

function plusSlides(n){
  clearInterval(myTimer);
  if (n < 0){
    showSlides(slideIndex -= 1);
  } else {
   showSlides(slideIndex += 1); 
  }
  if (n === -1){
    myTimer = setInterval(function(){plusSlides(n + 2)}, 4000);
  } else {
    myTimer = setInterval(function(){plusSlides(n + 1)}, 4000);
  }
}

    function showSlides(n){
  var i;
  var slides = document.getElementsByClassName("option");
  var dots = document.getElementsByClassName("dot");
  if (n > slides.length) {slideIndex = 1}
  if (n < 1) {slideIndex = slides.length}
  for (i = 0; i < slides.length; i++) {
      slides[i].style.display = "none";
  }
  for (i = 0; i < dots.length; i++) {
      dots[i].className = dots[i].className.replace(" active", "");
  }
  slides[slideIndex-1].style.display = "block";
  dots[slideIndex-1].className += " active";
}

window.addEventListener("load",function() {
    showSlides(slideIndex);
    myTimer = setInterval(function(){plusSlides(1)}, 4000);
})
</script>


@endsection
