<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header">
				<h4 class="header-title text-center"><?php echo e(_lang('Wire Transfer')); ?></h4>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('transfer.wire_transfer')); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>

					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Bank Name')); ?></label>
								<input type="text" class="form-control" name="td[bank_name]" id="bank" required>
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Swift Code')); ?></label>
								<input type="text" class="form-control" name="td[swift]" id="swift" required>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Account Type')); ?></label>
								<select class="form-control auto-select select2" required name="td[acc_type]">
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<option value="Savings">Savings Account</option>
                                        <option value="Current">Current Account</option>
                                        <option value="Checking">Checking Account</option>
                                        <option value="Fixed Deposit">Fixed Deposit</option>
                                        <option value="Non Resident">Non Resident Account</option>
                                        <option value="Online Banking">Online Banking</option>
                                        <option value="Domicilary Account">Domicilary Account</option>
                                        <option value="Joint Account">Joint Account</option>
								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Currency')); ?></label>
								<select class="form-control auto-select select2"  name="currency" id="currency" required>
								    <option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php echo e(create_option('currency','id','name','',array('status=' => 1))); ?>

								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Beneficiary Account Number')); ?></label>
								<input type="text" class="form-control" name="td[account_number]" value="<?php echo e(old('td.account_number')); ?>" required>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Beneficiary Account Name')); ?></label>
								<input type="text" class="form-control" name="td[account_holder_name]" value="<?php echo e(old('td.account_holder_name')); ?>" required>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Amount')); ?></label>
								<input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
								<small id="amount_limit"></small>
								<p class="text-info" id="fee"></p>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Note')); ?></label>
								<textarea class="form-control" name="note"><?php echo e(old('note')); ?></textarea>
							</div>
						</div>

						<div class="col-md-12">
							<h6 id="instructions"></h6>
						</div>

						<div class="col-md-12 mt-4">
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-lg btn-block"><i class="icofont-check-circled"></i> <?php echo e(_lang('Submit')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<!--<script>-->
<!--(function ($) {-->
<!--  "use strict";-->
<!--	$(document).on('change','#bank',function(){-->
<!--		if($(this).val() != ''){-->
<!--			$.ajax({-->
<!--				url: "<?php echo e(route('transfer.get_other_bank_details')); ?>" + "/" + $(this).val(),-->
<!--				success: function(data){-->
<!--					var currency = data['currency']['name'];-->
<!--					$("#swift_code").val(data['swift_code']);-->
<!--					$("#currency").val(currency);-->
<!--					$("#instructions").html(data['descriptions']);-->
<!--					$("#fee").html("<?php echo e(_lang('Transaction Fee')); ?> " + currency +' '+ data['fixed_charge'] + " + " + data['charge_in_percentage'] + "%");-->
<!--					$("#amount_limit").text("<?php echo e(_lang('Transfer Limit')); ?> (" + currency + " " + data['minimum_transfer_amount'] + " - " + currency + " " + data['maximum_transfer_amount'] + ")");-->
<!--				}-->
<!--			})-->
<!--		}-->
<!--	});-->
<!--})(jQuery);-->
<!--</script>-->
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/standa13/public_html/resources/views/backend/customer_portal/wire_transfer.blade.php ENDPATH**/ ?>