<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class AccessTokenOptions {
    /**
     * @param string $factorFriendlyName The factor friendly name
     * @return CreateAccessTokenOptions Options builder
     */
    public static function create(string $factorFriendlyName = Values::NONE): CreateAccessTokenOptions {
        return new CreateAccessTokenOptions($factorFriendlyName);
    }
}

class CreateAccessTokenOptions extends Options {
    /**
     * @param string $factorFriendlyName The factor friendly name
     */
    public function __construct(string $factorFriendlyName = Values::NONE) {
        $this->options['factorFriendlyName'] = $factorFriendlyName;
    }

    /**
     * The friendly name of the factor that is going to be created with this access token
     *
     * @param string $factorFriendlyName The factor friendly name
     * @return $this Fluent Builder
     */
    public function setFactorFriendlyName(string $factorFriendlyName): self {
        $this->options['factorFriendlyName'] = $factorFriendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.CreateAccessTokenOptions ' . $options . ']';
    }
}